#!/bin/sh
chmod u+x StarIOCheck.sh

echo "" >> checkRootAll.tmp
echo "" >> checkSuccess.tmp

checkRootAll=`cat checkRootAll.tmp | grep -i "true"`

logFilePath=usrLog/deviceLog.txt
IPSearch="[0-9]\{1,3\}\.[0-9]\{1,3\}\.[0-9]\{1,3\}\.[0-9]\{1,3\}"

# Distribution Check
distribution=`cat /etc/issue | sed -n '1p' | cut -d" " -f1`

# Wait the input enter key
waitNextStep ()
{
    echo ""
    echo "Go to next? (y/n)"
    read key

    if [ "$key" = "y" ];
    then
        echo ""
    else
        cd ../
        rm -f *.tmp
        exit
    fi
}

# Set the green color
greenColor ()
{
    if [ "$distribution" = "Ubuntu" ]
    then
        echo -n "[;33m"
    else
        echo -n ""
    fi
}

# Set the red color
redColor ()
{
    if [ "$distribution" = "Ubuntu" ]
    then
        echo -n "[;31m"
    else
        echo -n ""
    fi
}

# Set the default color
defaultColor ()
{
    if [ "$distribution" = "Ubuntu" ]
    then
        echo -n "[;m"
    else
        echo -n ""
    fi
}

# Set the line feed
LF ()
{
    echo ""
}

# Show the success message
ShowSuccessMsg ()
{
    greenColor
    echo "$successMsg"
    LF
    defaultColor
}

# Show the error message
ShowErrorMsg ()
{
    redColor
    echo "$errorMsg"
    LF
    defaultColor

    if [ "$checkRootAll" = "" ];
    then
        cd ../
        rm -f *.tmp
    fi

    exit 0
}

# Create the message that the port do not found
ShowPortNotFoundMsg ()
{
    errorMsg=`echo "The communication port do not found." &&
              echo "*Please check the interface controller on PC" &&
              echo "or the connection with PC and Printer."`
    ShowErrorMsg
}

# Create the message that the invalid number is inputed
ShowInvalidNumberMsg ()
{
    errorMsg=`echo "the input number is invalid."`
    ShowErrorMsg
}

# change directry for execute sample file
cd Software

# "Phase 1" explanation
greenColor
echo "---------------------------------- [Phase 1] ----------------------------------"
echo "The \"Phase 1\" find the port which is on PC,"
echo "and check the connection between PC and Printer or CashDrawer Device."
defaultColor
waitNextStep

# Kernel version check
echo "[Kernel Check]"

kernelVersion=`uname -r | cut -c1,3`

if [ $kernelVersion -ge 26 ];
then
    successMsg=`echo "kernel Check Success" && uname -r`
    ShowSuccessMsg
else
    errorMsg=`echo "This kernel version is not supported," &&
              echo "so please upgrade the kernel version which is later 2.6."`
    ShowErrorMsg
fi

# Select port
echo "[Select the using port]"
echo "1:serial"
echo "2:parallel"
echo "3:ethernet"
echo "4:usb"
echo "5:bluetooth(SPP)"
LF
echo "Input the number:"
read portNumber
LF

# Port check
case $portNumber in
1)
    port=`setserial -g /dev/ttyS* | grep "16550A"`

    if [ "$port" != "" ];
    then
        portList=`echo "$port" | cut -d',' -f1 | grep -n ''`
    else
        ShowPortNotFoundMsg
    fi
    ;;
2)
    port=`find /dev/parport*`

    if [ "$port" != "" ];
    then
        portList=`echo "$port" | grep -n ''`
    else
        ShowPortNotFoundMsg 
    fi
    ;;
3)
    # Port null check
    nullCheck ()
    {
        if [ "$checkName" = "" ];
        then
            errorMsg=`echo "$failedName check failed." &&
                      echo "*Please check $errorFactor." &&
                      echo "*Or please execute this program by the administrator authority." &&
                      echo "$uniqueMsg"`
            ShowErrorMsg
        fi
    }

    echo "*Checking network environment...\n"
    # Check local roop back
    checkLIP=`ifconfig | grep "inet addr:127"`
    
    if [ "$checkLIP" = "" ];
        then
        LIP=`ifconfig | grep "inet 127" | sed s/" "" "*//g | cut -c 5- \
                      | sed s/"netmask$IPSearch"//g`
    else
        LIP=`echo "$checkLIP" | sed s/" "" "*//g | cut -c 10- \
                              | sed s/"Mask:$IPSearch"//g`
    fi

    # Check local IP address
    checkName="$LIP"
    failedName="Local loop back IP"
    errorFactor="the Ethernet Controller with PC"
    uniqueMsg="*TCP/IP settings are invalid."
    nullCheck

    # Check local IP Connection   
    checkLIP=`ping -c 5 $LIP | grep -i "5 received, 0% packet loss"`

    checkName="$checkLIP"
    failedName="Local loop back connection"
    errorFactor="the Ethernet Controller with PC"
    uniqueMsg="*Or please check the local IP adress with PC."
    nullCheck

    # Check PC's IP address
    checkIP=`ifconfig | grep "inet addr"`
                 
    if [ "$checkIP" = "" ];
        then
        IP=`ifconfig | grep "inet " | grep -v "inet 127" |  sed s/" "" "*//g | cut -c 5- \
                     | sed s/"broadcast$IPSearch"//g \
                     | sed s/"netmask$IPSearch"//g`
    else
        IP=`echo "$checkIP" | grep -v "inet addr:127" |  sed s/" "" "*//g | cut -c 10- \
                            | sed s/"Bcast:$IPSearch"//g \
                            | sed s/"Mask:$IPSearch"//g`
    fi

#\.[0-9]\{1,3\}
    checkName="$IP"
    failedName="Ethernet connection"
    errorFactor="the network connection with PC"
    uniqueMsg=""
    nullCheck

    # Make portList
    portList=`echo "HOST PC Adress: $IP"`

    ;;
4)
    # The usb_vender_class is not support more than two device.
    checkNumberOfUsbDevice ()
    {
        if [ $vendorClassCheck -ge 2 ];
        then
            errorMsg=`echo "Please connect one printer,"
                      echo "when the printer has an interface of \"usb_vender_class\"."
                      echo "This tool is not support for the two or more \"usb_vendor_class\" printers."`
            ShowErrorMsg
        fi
    }

    if lsusb | grep -i "star" 1> /dev/null
    then
        usbInf=`lsusb -v | grep -iA26 "0x0519"`
        adminCheckList=`echo "$usbInf" | grep -i "iProduct" | sed s/" "" "" "*//g\
                                      | sed s/"iProduct[0-9][0-9]*"//g | sed s/^" "//g | grep -n ''`
        if [ "$adminCheckList" = "" ];
        then
            errorMsg=`echo "*Please execute this program by the administrator authority."`
            ShowErrorMsg
        fi

        vendorClassCheck=`echo "$usbInf" | grep bInterfaceClass | grep -i "Vendor" | wc -l`
        printerClassCheck=`echo "$usbInf" | grep bInterfaceClass | grep -i "Printer" | wc -l`
        printerClassPrinter=`echo "$usbInf" | grep -iB25 "Printer" | grep -i "iProduct" | sed s/" "" "" "*//g\
                                            | sed s/"iProduct[0-9][0-9]*"//g | sed s/^" "//g | grep -n ''`

        if [ $vendorClassCheck -ge 1 ] && [ $printerClassCheck = 0 ];
        then
            checkNumberOfUsbDevice

            portList="1:usbven:"
        elif [ $printerClassCheck -ge 1 ] && [ $vendorClassCheck = 0 ];
        then
           portList="$adminCheckList"
        else
            checkNumberOfUsbDevice

            i=`echo "$printerClassPrinter" | wc -l`
            i=`expr $i + 1`
            portList="usbven:"
            portList="$printerClassPrinter\n""$i:""$portList"
        fi
    else
        ShowPortNotFoundMsg
    fi
    ;;
5)
    key="y"

    btDevice=`rfcomm -a`

    if [ "$btDevice" != "" ]
    then
        echo "[registered bluetooth device]"
        echo "$btDevice"
        LF
        echo "Need to add another bluetooth printer or cashdrawer device?(y/n)"
        read key

        if [ "$key" = "y" ];
        then
            echo "Please pair with the bluetooth printer or cashdrawer device before going to next step."
            echo "The pairing is done?(y/n)"
            read key

            if [ "$key" = "y" ];
            then
                echo ""
            else
                echo ""
                echo "Please pair with the bluetooth printer or cashdrawer device. And restart the CheckStart.sh after paring."
                cd ../
                rm -f *.tmp
                exit
            fi
        else
            portList=`echo "$btDevice" | grep -n ''`
            break;
        fi
    fi
    
    if [ "$key" = "y" ]
    then
        echo "Scanning..."
        btCheck=`hcitool scan`
        btList=`echo "$btCheck" | grep "00:12:F3" | cut -f2- | grep -n ""`
        LF
        echo "$btList"
        LF
        echo "Select the number of using device:"
        read btNumber
    
        if [ "$btNumber" = "" ]
        then
            cd ../
            rm -f *.tmp
            exit
        fi

        btMAC=`echo "$btList" | grep ^$btNumber: | sed s/^$btNumber://g | cut -b1-17`

        rfcommList=`ls /dev/ | grep rfcomm`

        rfcommNumber=`echo "$rfcommList" | wc -l`
    
        if [ "$rfcommList" = "" ]
        then
            rfcommNumber=0
        fi

        btPortNumber=`echo $rfcommNumber`

        if [ "$rfcommNumber" != 0 ]
        then
            for i in `seq 1 "$rfcommNumber"`
            do
                checkBT=`echo "$rfcommList" | grep "rfcomm""$btPortNumber"`
                if [ "$checkBT" != "" ]
                then
                    btPortNumber=`expr $btPortNumber + 1`
                else
                    break;
                fi
            done
        fi

        rfcomm -S bind "$btPortNumber" "$btMAC"

        port="rfcomm""$btPortNumber"

        if [ "$port" != "" ];
        then
            portList=`echo "$port" | grep -n ''`
        else
            ShowPortNotFoundMsg
        fi
    fi
    ;;
*)
    ShowInvalidNumberMsg
    ;;
esac

# Show found port
echo "[found port]"
greenColor
echo "$portList"
LF
echo "[Phase 1] Check Success"
LF

echo "---------------------------------- [Phase 2] ----------------------------------"
echo "The \"Phase 2\" check the communication between PC and Printer or CashDrawer Device by StarIO library."
LF
defaultColor
waitNextStep

logFilePath=usrLog/StarIOPortLog.txt
testFileName=StarIOPort_Sample

# file check method
checkFile ()
{
    echo "[\"$fileName\" Check]"

    if find . -maxdepth 1 -name $fileName | grep -i "./$fileName"
    then
        successMsg=`echo "$fileName exist"`
        ShowSuccessMsg
    else
        errorMsg=`echo "$fileName do not exist." &&
                  echo "*Please put on the \"$fileName\" in the Directry" &&
                  echo "which there is \"$testFileName\"."`
        ShowErrorMsg
    fi
}

# LF insert for log
LF >> ./$logFilePath

# "libStarIOPort" Check
#fileName=libStarIOPort.so
#checkFile  | tee -a ./$logFilePath

# "StarIOPort_Sample" Check
fileName=$testFileName
checkFile  | tee -a ./$logFilePath

# Input the portName and the portSettings
LF
echo "e.g.) [serial]            /dev/ttyS0
      [parallel]          /dev/parport0
      [ethernet]          tcp:192.***.***.***
      [usb_vendor_class]  usbven:
      [usb_printer_class] usbprn:TSP700II
      [bluetooth(SPP)]    /dev/rfcomm0"
LF


echo "[Select the portName]"

# Port check
case $portNumber in
# 1)
#
#    ;;
# 2)
#
#    ;;
3)
    # Port null check
    nullCheck ()
    {
        if [ "$checkName" = "" ];
        then
            errorMsg=`echo "$failedName check failed." &&
                      echo "*Please check $errorFactor." &&
                      echo "*Or please execute this program by the administrator authority." &&
                      echo "$uniqueMsg"`
            rm -f searchList.tmp
            ShowErrorMsg
        fi
    }

    echo "*Searching printer's IP Address..."

    # Check PC's IP address
    #IP=`ifconfig | grep "inet addr" | grep -v "inet addr:127" |  sed s/" "" "*//g | cut -c 10- \
    #             | sed s/"\.[0-9]\{1,3\}Bcast:$IPSearch"//g \
    #             | sed s/"Mask:$IPSearch"//g`

    #IP=`ifconfig | grep "inet addr" | grep -v "inet addr:127" |  sed s/" "" "*//g`
    IP=`echo "$IP" | grep -n "" | grep "1:" | sed s/^"1:"//g`
    IP=`echo "$IP" | sed s/"\.[0-9]\{1,3\}"$//g`

    # Check PC and Printer communication
    prePort=`nmap -sP $IP.1-255 | grep -iB2 "MAC Address: 00:11:62" | grep -i "$IPSearch"`

    for x in $(seq 1 50)
    do
    port=`echo "$prePort" | cut -d" " -f$x | sed s/" "" "*//g`
    echo "$port" >> searchList.tmp
    done

    port=`cat searchList.tmp | grep -i "$IPSearch"`    

    checkName="$port"
    failedName="Ethernet connection"
    errorFactor="the connection with PC and Printer"
    uniqueMsg="*Or please check the IP adress with Printer."
    nullCheck

    # Make portList
    portList=`echo "$port" | grep -n ''`
    rm -f searchList.tmp
    ;;
# 4)
#    ;;
*)
    ;;
esac

# Show port
echo "$portList"

# Input using port number
LF
echo "Input the number:"
read portNameNumber

case $portNumber in
# 1)
#
#    ;;
# 2)
#
#    ;;
# 3)
#    ;;
# 4)
#    ;;
5)
  portList=`echo "$portList" | grep ^$portNameNumber: |  cut -d " " -f 1 | sed s/:$//g`
  ;;
*)
  ;;
esac
# Decide using portName
portName=`echo "$portList" | grep ^$portNameNumber: | sed s/^$portNameNumber://g`

if [ "$portName" = "" ];
then
    errorMsg=`echo "the portName do not found." &&
              echo "*Please select the number displayed."`
    ShowErrorMsg
fi


# for ethernet or usb portName 
case $portNumber in
#COMMENT_OUT
# 1)
#    ;;
# 2)
#    ;;
#COMMENT_OUT
3)
    portName=`echo "tcp:$portName"`
    ;;
4)
    if [ "$portName" != "usbven:" ];
    then
        portName=`echo "$portName" | sed s/"[Ss][Tt][Aa][Rr]"" "" "*//g` 
        portName=`echo "usbprn:$portName"`
    fi
    ;;

5)
    portName=`echo "/dev/$portName"`
    ;;
*)
    ;;
esac

# Decide using portSettins
case $portNumber in
1)
    LF
    echo "e.g) [except serial] \"\"
     [serial] \"38400,n,8,1,n\""
    LF
    echo "[Select the portSettings]"

    echo "[\"baud rates\"]"
    echo "1:38400"
    echo "2:19200"
    echo "3:9600"
    echo "4:4800"
    LF

    echo "Input the number:"
    read baudRates

    case $baudRates in
    1)
        baudRates=38400
        ;;
    2)
        baudRates=19200
        ;;
    3)
        baudRates=9600
        ;;
    4)
        baudRates=4800
        ;;
    *)
        ShowInvalidNumberMsg
        ;;
    esac

    LF
    echo "[parity]"
    echo "1:n (For none.)"
    echo "2:e (For even.)"
    echo "3:o (For odd.)"
    LF

    echo "Input the number:"
    read parity

    case $parity in
    1)
        parity=n
        ;;
    2)
        parity=e
        ;;
    3)
        parity=o
        ;;
    *)
        ShowInvalidNumberMsg
        ;;
    esac

    LF
    echo "[flowControl]"
    echo "1:n (For no flow control.)"
    echo "2:h (For hardware flow control.)"
    LF

    echo "Input the number:"
    read flowControl

    case $flowControl in
    1)
        flowControl=n
        ;;
    2)
        flowControl=h
        ;;
    *)
        ShowInvalidNumberMsg
        ;;
    esac

    portSettings="$baudRates,$parity,8,1,$flowControl"
    ;;
*)
    portSettings=""
    ;;
esac

echo "portName: $portName"
echo "portSettings: $portSettings" | tee -a $logFilePath

LF
# Decide test number
echo "[The type of test]"
echo "1:Printer Test"
echo "2:Cashdrawer Test"

# Input using test number
LF
echo "Input the type of the test number:"
read testTypeNumber

case $testTypeNumber in
1)
    # execute StarIO_Sample Printer Test
    chmod u+x StarIOPort_Sample
    checkExecute=`./StarIOPort_Sample  "$portName" "$portSettings"`
    ;;
2)
    # execute StarIO_Sample CashDrawer Test
    chmod u+x StarIOPort_Sample
    checkExecute=`./StarIOPort_Sample  "$portName" "$portSettings" "C"`
    ;;
*)
    ;;
esac

echo "$checkExecute" | tee -a $logFilePath
LF

# change directry for tmp file check
cd ../

# when StarIOCheck.sh execute
if [ "$checkRootAll" = "" ]
then
    successMsg=`echo "[Phase 2] Check Success"`
    ShowSuccessMsg

    rm -f *.tmp

fi

# when CheckStart.sh execute
checkExecuteSuccess=`echo "$checkExecute" | grep -i "Success - Close Port"`
if [ "$checkExecuteSuccess" = "" ]
then
    echo "" > ./checkSuccess.tmp
else
    if [ "$testTypeNumber" = "2" ]
    then
        echo "true" > ./cashDrawer.tmp
    fi

    echo "$portName" > ./portName.tmp
    echo "$portSettings" > ./portSettings.tmp
    echo "true" > ./checkSuccess.tmp

    successMsg=`echo "[Phase 2] Check Success"`
    ShowSuccessMsg
fi

exit 0
