#!/bin/sh
chmod u+x StarJavaPOSCheck.sh

portName=`cat ./portName.tmp`
portSettings=`cat ./portSettings.tmp`

checkCashDrawerFile=`ls . | grep cashDrawer.tmp`

if [ "$checkCashDrawerFile" != "" ];
then
    checkCashDrawer=`cat ./cashDrawer.tmp | grep -i "true"`
fi


# Distribution Check
distribution=`cat /etc/issue | sed -n '1p' | cut -d" " -f1`

# Wait the input enter key
WaitNextStep ()
{
    echo "Go to next? (y/n)"
    read key

    if [ "$key" = "y" ];
    then
        echo ""
    else
        cd ../
        rm -f *.tmp
        exit
    fi
}

# Set the green color
GreenColor ()
{
    if [ "$distribution" = "Ubuntu" ]
    then
        echo -n "[;33m"
    else
        echo -n ""
    fi
}

# Set the red color
RedColor ()
{
    if [ "$distribution" = "Ubuntu" ]
    then
        echo -n "[;31m"
    else
        echo -n ""
    fi
}

# Set the default color
DefaultColor ()
{
    if [ "$distribution" = "Ubuntu" ]
    then
        echo -n "[;m"
    else
        echo -n ""
    fi
}

# Set the line feed
LF ()
{
    echo ""
}

# Show the success message
ShowSuccessMsg ()
{
    GreenColor
    echo "$successMsg"
    LF
    DefaultColor
}

# Show the error message
ShowErrorMsg ()
{
    RedColor
    echo "$errorMsg"
    LF
    DefaultColor

    if [ "$checkRootAll" = "" ];
    then
        cd ../
        rm -f *.tmp
    fi

    exit 0
}

successMsg=`echo "---------------------------------- [Phase 3] ----------------------------------" &&
            echo "The \"Phase 3\" check the communication between PC and Printer  or CashDrawer Device " &&
            echo "by StarIO library based on java."`
ShowSuccessMsg
WaitNextStep

logFilePath=Software/usrLog/StarIO_java.txt
directryPath=Software
testFileName=StarIO_Sample.class

# file check method
checkFile ()
{
    echo "[\"$fileName\" Check]"

    if find ./$directryPath -maxdepth 1 -name $fileName | grep -i "./$fileName"
    then
        successMsg=`echo "$fileName exist"`
        ShowSuccessMsg
    else
        errorMsg=`echo "$fileName do not exist" &&
                  echo "*Please put on the \"$fileName\" in the Directry" &&
                  echo "which there is \"$testFileName\"."`
        ShowErrorMsg
    fi
}

# LF insert for log
LF >> ./$logFilePath

# check JRE
#echo "[\"JRE\" Check]" | tee -a ./$logFilePath
#if update-alternatives --config java
#then
#    successMsg=`echo "\033[;33mJRE Check Success"`
#    ShowSuccessMsg
#else
#    errorMsg=`echo "JRE Check Failed"
#              echo "\"Please install the JRE which is"
#              echo "\"java version 1.4.2 or later\".(A recommendation version is 1.5.0 or later)."`
#    ShowErrorMsg
#fi

# check java version
echo "[\"Java JRE Version\" Check]" | tee -a ./$logFilePath
GreenColor
java -version
DefaultColor

echo "*Please check \"java version\" above message and choose y or n."
echo ""

echo "Is \"java version\" \"1.4.2 or later\"? (y/n)"
echo ""
read key

if [ "$key" = "y" ];
then
    successMsg=`echo "\"Java Version Check success.\""`
    ShowSuccessMsg
else
    errorMsg=`echo "\"Please install the JRE which is\"java version 1.4.2 or later\"."
              echo "(A recommendation version is 1.5.0 or later)."`
    ShowErrorMsg
    exit
fi

# "stario.jar" Check
fileName=stario.jar
checkFile  | tee -a ./$logFilePath

# "StarIO_Sample.class" Check
fileName="$testFileName"
checkFile  | tee -a ./$logFilePath

# change directry for compile java
cd $directryPath

# compile java source file
#javac -classpath stario.jar StarIO_Sample.java

#Input portName and portSettings
portName=$portName
portSettings=$portSettings

if [ "$portName" = "" ] && [ "$portSettings" = "" ]
then
    errorMsg=`echo "*Please input the portName or the portSettings."`
    ShowErrorMsg
    exit 0
fi 

echo "portName: $portName"
echo "portSettings: $portSettings"

# execute java class file
# chmod u+x StarIO_Sample
if [ "$checkCashDrawer" = "" ]
then
    check=`java -classpath stario.jar:. StarIO_Sample "$portName" "$portSettings"`
else
    check=`java -classpath stario.jar:. StarIO_Sample "$portName" "$portSettings" "C"`
fi

echo "$check" | tee -a ./usrLog/StarIO_java.txt
LF

checkResult=`echo "$check" | grep -i "Success - ClosePort"`

if [ "$checkResult" = "" ];
then
    cd ../
    rm -f *.tmp
    exit 0
fi

successMsg=`echo "[Phase 3] Check Success"`
ShowSuccessMsg

successMsg=`
echo "---------------------------------- [Phase 4] ----------------------------------"
echo "The \"Phase 4\" check the communication between PC and Printer or CashDrawer Device by StarJavaPOS library."`
ShowSuccessMsg

WaitNextStep

logFilePath=usrLog/StarJavaPOS.txt
directryPath= #JavaPOSCheckTestTool
testFileName=StarReceiptTest.class
 
# LF insert for log
LF >> ./$logFilePath

# "commandemulator.jar" Check
#fileName=commandemulator.jar
#checkFile | tee -a ./$logFilePath

# "jcl.jar" Check
fileName=jcl.jar
checkFile | tee -a ./$logFilePath

# "jpos.xml" Check
fileName=jpos.xml
checkFile | tee -a ./$logFilePath

# "jpos113-controls.jar" Check
fileName=jpos113-controls.jar
checkFile | tee -a ./$logFilePath

# "stario.jar" Check
fileName=stario.jar
checkFile | tee -a ./$logFilePath

# "starjavapos.jar" Check
fileName=starjavapos.jar
checkFile | tee -a ./$logFilePath

# "xercesimpl.jar" Check
fileName=xercesimpl.jar
checkFile | tee -a ./$logFilePath

# "xml-apis.jar" Check
fileName=xml-apis.jar
checkFile | tee -a ./$logFilePath

# "StarReceiptTest.calss" Check 
fileName=StarReceiptTest.class 
checkFile | tee -a ./$logFilePath

# XML file settings for StarJavaPOS 
echo "[XML file settings]" | tee -a ./$logFilePath
LF

# change directry for compile java
#cd $directryPath

# java source file compile (javac)
# javac -classpath jpos113-controls.jar:jcl.jar StarReceiptTest.java | tee -a ./usrLog/StarJavaPOS.txt

# search use portName
checkPort=`echo "$portName" | cut -c 1-4`

if [ "$checkCashDrawer" = "" ]
then
    if [ "$checkPort" = "/dev" ]
    then
        checkPort=`echo "$portName" | cut -c 1-6`

        if [ "$checkPort" = "/dev/p" ]
        then
        logicalName="POSPrinter_linux_parallel"

        elif [ "$checkPort" = "/dev/t" ]
        then
            logicalName="POSPrinter_linux_serial"

        elif [ "$checkPort" = "/dev/r" ]
        then
            logicalName="POSPrinter_linux_bluetooth"
        fi

    elif [ "$checkPort" = "usbp" ]
    then
        logicalName="POSPrinter_linux_usb_printer_class"

    elif [ "$checkPort" = "usbv" ]
    then
        logicalName="POSPrinter_linux_usb_vendor_class"

    elif [ "$checkPort" = "tcp:" ]
    then
        logicalName="POSPrinter_linux_ethernet"
    fi
else
    if [ "$checkPort" = "/dev" ]
    then
        checkPort=`echo "$portName" | cut -c 1-6`

        if [ "$checkPort" = "/dev/p" ]
        then
            logicalName="CashDrawer_linux_parallel"

        elif [ "$checkPort" = "/dev/t" ]
        then
            logicalName="CashDrawer_linux_serial"

        elif [ "$checkPort" = "/dev/r" ]
        then
            logicalName="CashDrawer_linux_bluetooth"
        fi

    elif [ "$checkPort" = "usbp" ]
    then
        logicalName="CashDrawer_linux_usb_printer_class"

    elif [ "$checkPort" = "usbv" ]
    then
        logicalName="CashDrawer_linux_usb_vendor_class"

    elif [ "$checkPort" = "tcp:" ]
    then
        logicalName="CashDrawer_linux_ethernet"
    fi
fi

pwd=`pwd`
jposLocationFullPath="$pwd/jpos.xml"

logicalNameList=`cat "$jposLocationFullPath" | grep -iA7 "$logicalName"`

# get using logicalName and portName and portSetting (not use now)
logicalNameList=`echo "$logicalNameList" | sed s/^" "" "*"<JposEntry logicalName=\""//g \
                                         | sed s/"\">".*//g \
                                         | sed s/^" "" "*"<prop name=\"model\" type=\"String\" value=\""//g \
                                         | sed s/^" "" "*"<prop name=\"portName\" type=\"String\" value=\""//g \
                                         | sed s/^" "" "*"<prop name=\"portSettings\" type=\"String\" value=\""//g \
                                         | sed s/\"" ".*//g \
                                         | sed -e "2, 5d"`

# Input the portName and portSettings in XML file
LF
echo "[Write JavaPOS settings in the XML file]"
echo "1. Open the \"XML file\" which is written about JavaPOS settings."
echo "\"XML File\" Location:"

successMsg=`echo ""$jposLocationFullPath""`
ShowSuccessMsg

WaitNextStep

if [ "$checkCashDrawer" = "" ]
then
    echo "2. Write the model and portName and portSettings in the \"XML File\""
    successMsg=`echo "Target logicalName:" $logicalName"" &&
                echo "" &&
                echo "model: using printer model name" &&
                echo " (e.g)FVP10, TSP847II, TSP700II, TSP654, etc..." &&
                echo "" &&
                echo "portName:" $portName"" &&
                echo "portSettings:" $portSettings""`
    ShowSuccessMsg

    echo "Write model, portName, portSetting and Save in the XML file? (y/n)"
    read key
else
    echo "2. Write the model and portName and portSettings in the \"XML File\""
    successMsg=`echo "Target logicalName:" $logicalName"" &&
                echo "" &&
                echo "portName:" $portName"" &&
                echo "portSettings:" $portSettings""`
    ShowSuccessMsg

    echo "Write portName, portSetting and Save in the XML file? (y/n)"
    read key
fi


if [ "$key" = "y" ];
then
    echo ""
else
    cd ../
    rm -f *.tmp
    exit
fi

# java execute (java)
#chmod u+x StarReceiptTest
if [ "$checkCashDrawer" = "" ]
then
    checkResult=`java -classpath .:starjavapos.jar:stario.jar:commandemulator.jar:jpos113-controls.jar:jcl.jar:xercesimpl.jar:xml-apis.jar StarReceiptTest "$jposLocationFullPath" "$logicalName"`
else
    checkResult=`java -classpath .:starjavapos.jar:stario.jar:commandemulator.jar:jpos113-controls.jar:jcl.jar:xercesimpl.jar:xml-apis.jar StarCashDrawerTest "$jposLocationFullPath" "$logicalName"`
fi

echo "$checkResult" | tee -a ./usrLog/StarJavaPOS.txt

checkResult=`echo "$checkResult" | grep -i "Close - Success"`

if [ "$checkResult" = "" ];
then
    cd ../
    rm -f *.tmp
    exit 0
fi

successMsg=`echo "[Phase 4] Check Success"`
ShowSuccessMsg

cd ../
rm -f *.tmp

exit 0

