﻿#pragma warning(disable:4996)
#pragma warning(disable:4127)

#include <windows.h>
#include <conio.h> /*_kbhit()*/
#include <stdio.h>

#define PORT_NAME_LENGTH 100
void ShowPrinterStatus(PBYTE status, size_t size);
void PressAnyKey();
HANDLE comPortHandle;

#define STATUS_LENGTH          1
static const BYTE STATUS_REQUEST_COMMAND[] = { 0x10, 0x04, 0x01 }; /* DLE, EOT, 1 */
BOOL SendDataToPrinter(PBYTE printData, DWORD printDataSize);
BOOL GetPrinterStatus(PBYTE buffer, DWORD bufferSize);

int main(void)
{
    CHAR line[PORT_NAME_LENGTH];
    CHAR inputPortName[PORT_NAME_LENGTH];
    CHAR portName[PORT_NAME_LENGTH + 4]; /* EN: Add 4bytes to insert "\\.\" before the port name */
                                         /* JP: ポート名の頭に "\\.\"を付加するため4byte追加 */
    PCHAR filename;

    HANDLE fileHandle;
    DWORD fileSize;
    DWORD readSize;

    DCB dcb;
    COMMTIMEOUTS timeouts;
    PBYTE printData = NULL;
    DWORD printDataSize = 0;

    /* Read/Write Timeout settings */
    timeouts.ReadIntervalTimeout         =     0;
    timeouts.ReadTotalTimeoutConstant    =  4000;
    timeouts.ReadTotalTimeoutMultiplier  =     0;
    timeouts.WriteTotalTimeoutConstant   = 10000;
    timeouts.WriteTotalTimeoutMultiplier =     0;
    SetCommTimeouts(comPortHandle, &timeouts);

    /* EN: Read print data from file */
    /* JP: 印刷データをファイルから読み込む */
    filename = "printData_Escpos.bin";
    fileHandle = CreateFileA(filename, GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
    if (fileHandle == INVALID_HANDLE_VALUE) {
        fprintf(stderr, "Could not open %s.\n", filename);
        PressAnyKey();
        return -1;
    }

    fileSize = GetFileSize(fileHandle, &fileSize);
    if (fileSize == INVALID_FILE_SIZE) {
        fprintf(stderr, "GetFileSize() failed. Error Number = %d\n", GetLastError());
        CloseHandle(fileHandle);
        PressAnyKey();
        return -1;
    }

    printDataSize = fileSize;
    printData = (PBYTE)malloc(printDataSize);
    if (printData == NULL) {
        fprintf(stderr, "Memory Allocation Error.\n");
        CloseHandle(fileHandle);
        PressAnyKey();
        return -1;
    }

    if (ReadFile(fileHandle, printData, printDataSize, &readSize, NULL) == FALSE) {
        fprintf(stderr, "ReadFile() failed. Error Number = %d\n", GetLastError());
        free(printData);
        CloseHandle(fileHandle);
        return -1;
    }

    CloseHandle(fileHandle);

    /* Open port */
    do {
        printf("Input COM Port Name (ex. COM1) : ");
        fgets(line, sizeof(line), stdin);
        sscanf(line, "%s", inputPortName);
    } while (strcmp(line, "\n") == 0);
    printf("\n");

    sprintf_s(portName, sizeof(portName), "\\\\.\\%s", inputPortName);

    comPortHandle = CreateFileA(portName, GENERIC_READ | GENERIC_WRITE, 0, 0, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
    if (comPortHandle == INVALID_HANDLE_VALUE) {
        fprintf(stderr, "CreateFile() failed. Error Code %d\n", GetLastError());
        PressAnyKey();
        free(printData);
        return -1;
    }

    /* EN: Set com port */
    /*     The following settings are not supported by the Virtual Serial Port feature*/
    /* JP: ポート設定 */
    /*     VPEでは機能しない */
    GetCommState(comPortHandle, &dcb);
    dcb.BaudRate = 9600;
    dcb.Parity = NOPARITY;
    dcb.ByteSize = 8;
    dcb.StopBits = ONESTOPBIT;
    dcb.fDsrSensitivity = TRUE;
    dcb.fDtrControl = TRUE;
    dcb.fRtsControl = TRUE;
    SetCommState(comPortHandle, &dcb);

    printf("BaudRate: 9600bps\n");
    printf("Parity:   None\n");
    printf("ByteSize: 8\n");
    printf("StopBits: 1\n");
    printf("Flow:     DTR\n\n");

    while(1) {
        char answer[100];
        BOOL result = FALSE;

        /* EN: Send data */
        /* JP: 送信実行 */
        result = SendDataToPrinter(printData, printDataSize);
        if (result != FALSE)  {
            printf("Success.\n");
            break;
        }

        printf("Failed.\n\n");

        /* Retry */
        do {
            printf("Retry? [y/n] : ");
            fgets(line, sizeof(line), stdin);
            sscanf(line, "%s", answer);
        } while ((strcmp(line, "y\n") != 0) && (strcmp(line, "n\n") != 0));
        printf("\n");

        if (strcmp(answer, "n") == 0)
            break;
    }

    if (printData != NULL)
        free(printData);

    CloseHandle(comPortHandle);
    PressAnyKey();

    return 0;
}

BOOL SendDataToPrinter(PBYTE printData, DWORD printDataSize) {
    DWORD numWritten = 0;
    BYTE status[STATUS_LENGTH];
    BOOL result = FALSE;

    /* EN: Request status*/
    /* JP: ステータス要求*/
    result = GetPrinterStatus(status, STATUS_LENGTH);
    if (result == FALSE)  {
        return FALSE;
    }

    printf("Before: ");
    ShowPrinterStatus(status, STATUS_LENGTH);

    if (status[0] & 0x08) { /* 3 Bit: ON = Printer Error (Offline) */
        fprintf(stderr, "Printer off-line detected.\n");
        return FALSE;
    }

    /* EN: Send data */
    /* JP: 印刷データ送信 */
    if (WriteFile(comPortHandle, printData, printDataSize, &numWritten, NULL) == FALSE) {
        fprintf(stderr, "WriteFile() failed. Error Code %d\n", GetLastError());
        return FALSE;
    }

    if (numWritten < printDataSize) {
        fprintf(stderr, "WriteFile() failed. Error Code %d\n", GetLastError());
        return FALSE;
    }

    /* EN: Keep the process until the print job is completed (for 2seconds)*/
    /* JP: 印刷完了まで待機 (ここでは2秒)*/
    Sleep(2000L);

    /* EN: Request status*/
    /* JP: ステータス要求*/
    result = GetPrinterStatus(status, STATUS_LENGTH);
    if (result == FALSE) {
        return FALSE;
    }

    printf("After : ");
    ShowPrinterStatus(status, STATUS_LENGTH);
    if (status[0] & 0x08) { /* 3 Bit: ON = Printer Error (Offline) */
        fprintf(stderr, "Printer off-line detected.\n");
        return FALSE;
    }

    return TRUE;
}

BOOL GetPrinterStatus(PBYTE buffer, DWORD bufferSize)
{
    BOOL result = FALSE;
    DWORD numWritten = 0, numRead = 0;
    DCB dcb;
    unsigned int dtrControl;

    /* EN: Change flow control to disable */
    /* JP: 一時的にフロー制御を無効にする。*/
    GetCommState(comPortHandle, &dcb);
    dtrControl = dcb.fDtrControl;
    dcb.fDtrControl = FALSE;
    SetCommState(comPortHandle, &dcb);

    dcb.fDtrControl = dtrControl;

    if (bufferSize < STATUS_LENGTH) {
        SetCommState(comPortHandle, &dcb);
        return FALSE;
    }

    /* EN: Request status */
    /* JP: ステータス要求 */
    result = WriteFile(comPortHandle, STATUS_REQUEST_COMMAND, sizeof(STATUS_REQUEST_COMMAND), &numWritten, NULL);
    if (result == FALSE) {
        fprintf(stderr, "WriteFile() failed. Error Code: %d\n", GetLastError());
        SetCommState(comPortHandle, &dcb);
        return FALSE;
    }

    if (numWritten < sizeof(STATUS_REQUEST_COMMAND)) {
        fprintf(stderr, "WriteFile() failed. Error Code: %d\n", GetLastError());
        SetCommState(comPortHandle, &dcb);
        return FALSE;
    }

    Sleep(200L);

    result = ReadFile(comPortHandle, buffer, bufferSize, &numRead, NULL);
    if ((result == FALSE) || (numRead == 0)) {
        fprintf(stderr, "ReadFile() failed. Error Code: %d\n", GetLastError());
        SetCommState(comPortHandle, &dcb);
        return FALSE;
    }

    /* EN: Reset flow control to enable from disable */
    /* JP: フロー制御設定を元に戻す */
    SetCommState(comPortHandle, &dcb);

    return TRUE;
}

void ShowPrinterStatus(PBYTE status, size_t size)
{
    unsigned int i;
    for (i = 0; i < size; i++) {
        printf("%02x, ", status[i]);
    }
    printf("\n");
}

void PressAnyKey() {
    printf("-- Press Any Key. --");

    while (!_kbhit()) {
        Sleep(100L);
    }
}